#!/usr/bin/env python
# -*- coding: utf-8 -*-

from resource import GEOADMIN_DB_BACKUP
from sandbox.projects.geobase.common.builder import CommonBuilderTask


class GEOADMIN_DB_BACKUP_DUMPER(CommonBuilderTask):

    class Requirements(CommonBuilderTask.Requirements):
        pass

    class Parameters(CommonBuilderTask.Parameters):
        default_desc = "'geoadmin.db'@STABLE"
        description = default_desc

        ramdrive_size = 1

        datafile_type = "geodb"
        release_type = "stable"
        resource_ttl = "365"
        result_datafile = "geodb.tar.gz"

    class Context(CommonBuilderTask.Context):
        pass

    def get_own_resource_type(self):
        return GEOADMIN_DB_BACKUP

    def get_own_type(self):
        return GEOADMIN_DB_BACKUP_DUMPER
