#!/usr/bin/env python
# -*- coding: utf-8 -*-

from resource import GEODATA5BIN_XURMA_STABLE
from sandbox.projects.geobase.common.builder import CommonBuilderTask


class GEODATA5BIN_XURMA_STABLE_BUILDER(CommonBuilderTask):

    class Requirements(CommonBuilderTask.Requirements):
        pass

    class Parameters(CommonBuilderTask.Parameters):
        default_desc = "'geodata5-xurma.bin'@STABLE"
        description = default_desc

        ramdrive_size = 2

        datafile_type = "geodata5-xurma"
        release_type = "stable"
        resource_ttl = "inf"
        result_datafile = "geodata5-xurma.bin"

    class Context(CommonBuilderTask.Context):
        pass

    def get_own_resource_type(self):
        return GEODATA5BIN_XURMA_STABLE

    def get_own_type(self):
        return GEODATA5BIN_XURMA_STABLE_BUILDER
