#!/usr/bin/env python
# -*- coding: utf-8 -*-

from resource import GEODATA6BIN_EXP
from sandbox.projects.geobase.common.builder import CommonBuilderTask


class GEODATA6BIN_EXP_BUILDER(CommonBuilderTask):

    class Requirements(CommonBuilderTask.Requirements):
        pass

    class Parameters(CommonBuilderTask.Parameters):
        default_desc = "'geodata6.bin'@EXP"
        description = default_desc

        ramdrive_size = 36

        datafile_type = "geodata6"
        release_type = "unstable"
        resource_ttl = "inf"
        result_datafile = "geodata6.bin"

    class Context(CommonBuilderTask.Context):
        pass

    def get_own_resource_type(self):
        return GEODATA6BIN_EXP

    def get_own_type(self):
        return GEODATA6BIN_EXP_BUILDER
