#!/usr/bin/env python
# -*- coding: utf-8 -*-

from resource import GEODATA_TREE_LING_STABLE
from sandbox.projects.geobase.common.builder import CommonBuilderTask


class GEODATA_TREE_LING_STABLE_BUILDER(CommonBuilderTask):

    class Requirements(CommonBuilderTask.Requirements):
        pass

    class Parameters(CommonBuilderTask.Parameters):
        default_desc = "'geodata4-tree+ling.bin'@STABLE"
        description = default_desc

        ramdrive_size = 1

        datafile_type = "geodata-treeling"
        release_type = "stable"
        resource_ttl = "inf"
        result_datafile = "geodata4-tree+ling.bin"

    class Context(CommonBuilderTask.Context):
        pass

    def get_own_resource_type(self):
        return GEODATA_TREE_LING_STABLE

    def get_own_type(self):
        return GEODATA_TREE_LING_STABLE_BUILDER



#
# TODO(dieash@) commit sbr://${id} into 'kernel/geo/canonical_data/files/geodata_tree_ling/ya.make'
#
