#!/usr/bin/env python
# -*- coding: utf-8 -*-

from resource import GEODATA_TREE_LING_TESTING
from sandbox.projects.geobase.common.builder import CommonBuilderTask


class GEODATA_TREE_LING_TESTING_BUILDER(CommonBuilderTask):

    class Requirements(CommonBuilderTask.Requirements):
        pass

    class Parameters(CommonBuilderTask.Parameters):
        default_desc = "'geodata4-tree+ling.bin'@TESTING (gz)"
        description = default_desc

        ramdrive_size = 1

        datafile_type = "geodata-treeling"
        release_type = "testing"
        resource_ttl = "inf"
        result_datafile = "geodata4-tree+ling.tar.gz"

    class Context(CommonBuilderTask.Context):
        pass

    def get_own_resource_type(self):
        return GEODATA_TREE_LING_TESTING

    def get_own_type(self):
        return GEODATA_TREE_LING_TESTING_BUILDER
