#!/bin/sh -E

ipreg_bin="$1"
mmanon_patch="$2"
hpv_patch="$3"

script_dir="$(dirname $(readlink -f $0))"
mm_data="$(date +%Y%m%d).maxmind"

get_maxmind_yt_src() {
    local yt_traits_fname="yt.traits"
    local data_path=$(dirname ${ipreg_fname})
    . ${data_path}/${yt_traits_fname}

    YT_PROXY=${yt_proxy} YT_TOKEN=${yt_token} \
    yt read "//home/geotargeting/production/sources/maxmind" \
       --format "<columns=[key;value];missing_value_mode=print_sentinel;enable_escaping=false>schemaful_dsv"
}

extract_mm_bindings() {
    ${script_dir}/prepare-maxmind-data.py \
    | ${ipreg_bin}/ipreg-fmt --extract-json-attr code | sed 's/code/region_id/' \
    | ${ipreg_bin}/ipreg-merge \
    | ${ipreg_bin}/ipreg-add-stub \
    | ${ipreg_bin}/ipreg-fmt --extract-json-attr region_id \
    | ${ipreg_bin}/ipreg-check-addr-space --completeness
}

prepare_patch() {
    local patch_fname=$1

    if [ ! -s ${mm_data} ]; then
        get_maxmind_yt_src > ${mm_data}
    fi

    cat ${mm_data} \
    | extract_mm_bindings \
    | ${ipreg_bin}/ipreg-patch -p ${patch_fname} \
    | grep -E 'hosting|proxy|vpn' \
    | sed -e 's/region_id/mm_id/' \
    | tee ${hpv_patch}.alt \
    | sed -e 's/mm_id/region_id/' \
    | ${ipreg_bin}/ipreg-fmt --extract-json-attr region_id

    rm ${mm_data}
}

prepare_patch ${mmanon_patch} > ${hpv_patch}

