#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import ipaddr
import json
import geobase6

lookup = geobase6.Lookup(sys.argv[1])


for line in sys.stdin:
    traits = None
    try:
        traits = json.loads(line)
    except Exception, ex:
        print >>sys.stderr, ">>> FAIL: %s // %s" % (ex, line)

    mm_id = int(traits['mm_id'])
    reg_id = int(traits['region_id'])

    mm_large = lookup.is_id_in(reg_id, mm_id)
    print "is %d in %d? %d" % (reg_id, mm_id, mm_large)
