#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import ipaddr
import json


stats = {}


def inc_stat_counter(counter_name):
    stats[counter_name] = stats.get(counter_name, 0) + 1

row_num_for_show = int(sys.argv[1])
non_eq_counter = 0

for line in sys.stdin:
    line = line.strip()
    parts = line.split('\t')
    json_data = json.loads(parts[1])
    if json_data['mm_id'] == json_data['region_id']:
        inc_stat_counter('EQ')
    else:
        inc_stat_counter('NOT-EQ')
        non_eq_counter += 1
        if 0 == (non_eq_counter % row_num_for_show):
            print >>sys.stderr, line

stats_str = json.dumps(stats, sort_keys=True, indent=4, separators=(',',':'))
print >>sys.stderr, stats_str
