#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import ipaddr
import json


def print_row(lst_range, lst_traits):
    if not lst_range or not lst_traits:
        return

    print "%s\t%s" % (lst_range, lst_traits)


lst_range = ""
lst_traits = ""


for line in sys.stdin:
    if not line[0].isdigit():
        continue

    curr_range,curr_traits = line.strip().split('\t')
    if lst_range != curr_range:
        print_row(lst_range, lst_traits)

        lst_range = curr_range
        lst_traits = curr_traits
        continue

    if '"source_type":4' in curr_traits:
        lst_traits = curr_traits

print_row(lst_range, lst_traits)

