#!/usr/bin/env python

import sys
import geobase5

l = geobase5.Lookup(sys.argv[1])
all_regs = l.tree(10000)

for reg in all_regs:
    if reg.type != -1 or reg.id == -1:
        continue

    what_id = l.region_id_by_location(reg.lat, reg.lon)
    if what_id == reg.id:
        print "%f\t%f\t%d\t%s\t%d" % (reg.lat, reg.lon, reg.id, reg.name, what_id)
