#! /usr/bin/env python

import sys
import geobase6


REMOVED_ROOT_ID = -1
REMOVED_TYPE = -1
CITY_TYPE = 6
VILLAGE_TYPE = 7

EARTH_ROOT_ID = 10000


def main(geodata_fname):
    lookup = geobase6.Lookup(geodata_fname)

    all_regions = lookup.get_tree(REMOVED_ROOT_ID)
    dangling_regions = [r for r in all_regions if r['type'] != REMOVED_TYPE]

    problems_qty = 0
    for r in dangling_regions:
        print "%d\t%d\t%d\t%s" % (r['id'], r['type'], r['parent_id'], r['name'])
        problems_qty += 1

    regions_list = lookup.get_tree(EARTH_ROOT_ID)
    regions_hash = {
        r['id']: { 'id': r['id'],
                   'cid': r['capital_id'],
                   'pid': r['parent_id'],
                   'type': r['type'] ,
                   'name': r['name']
                 } for r in regions_list
    }

    for reg_id, traits in regions_hash.iteritems():
        if traits['type'] == REMOVED_TYPE:
            continue

        parent = regions_hash.get(traits['pid'], None)
        if parent and parent['type'] == REMOVED_TYPE:
            print "BAD PARENT: %d\t%d\t%s => %d\t%d\t%s" % (traits['id'], traits['type'], traits['name'], parent['id'], parent['type'], parent['name'])
            problems_qty += 1

        capital = regions_hash.get(traits['cid'], None)
        if capital:
            if capital['type'] not in [ CITY_TYPE, VILLAGE_TYPE ]:
                print "BAD CAPITAL: %d\t%d\t%s => %d\t%d\t%s" % (traits['id'], traits['type'], traits['name'], capital['id'], capital['type'], capital['name'])
                problems_qty += 1

    return problems_qty


if __name__ == "__main__":
    sys.exit(main(sys.argv[1]))
