#!/usr/bin/env python

import sys
import netaddr

faked_isp_code = '0'  # was: 'NO-ISP'

ipv4_block = False
ipv6_block = False

prev_net = netaddr.IPNetwork("0.0.0.0/32")
prev_isp_name = faked_isp_code

prev_end = None
prev_begin = None

print "::\t::fffe:ffff:ffff\t" + faked_isp_code

for line in sys.stdin:
    line = line.strip()
    if not line or '#' == line[0]:
        continue

    parts = line.split('\t')
    if len(parts) < 2:
        sys.stderr.write(">>>NB: (not 2 columns):\t[%s]\n" % line)
        continue

    cidr = parts[0]
    isp_name = parts[1]

    net = netaddr.IPNetwork(cidr)
    if net in prev_net:
        if prev_isp_name != isp_name:
            sys.stderr.write(">>>NB: (maybe data-lost):\t%s\t%s\t%s\t%s\t# inner network\n" % (net, prev_net, isp_name, prev_isp_name))
        continue
    else:
        prev_net = net
    prev_isp_name = isp_name

    begin_range = net[0]
    prev_end = net[0] - 1

    if not ipv4_block:
        prev_begin = netaddr.IPAddress('::ffff:0.0.0.0')
        ipv4_block = True
    if not ipv6_block:
        if begin_range.version == 6:
            last_ipv4 = netaddr.IPAddress('::ffff:255.255.255.255')
            print "%s\t%s\t%s" % (prev_begin, last_ipv4, faked_isp_code)

            prev_begin = last_ipv4 + 1
            ipv6_block = True

    if prev_begin < prev_end:
        print "%s\t%s\t%s" % (prev_begin, prev_end, faked_isp_code)

    prev_begin = net[-1] + 1
    print "%s\t%s\t%s" % (begin_range, net[-1], isp_name)

last_ipv6 = "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"
print "%s\t%s\t%s" % (prev_begin, last_ipv6, faked_isp_code)
