#!/usr/bin/env python

import json
import netaddr  # NB: python-netaddr
import sys


def line2json(line):
    # TODO(dieash@) here is work-around for ISP-code := ASN-code; must be rewrited
    content = \
        line.lower() \
            .replace('=', '":"') \
            .replace('\t', '","')

    json_str = '{"%s"}' % content
    return json_str


def check_data(cidr, ispn, line):
    err_msg = ""

    if "" == cidr:
        err_msg += " CIDR-empty;"

    if "" == ispn:
        err_msg += " ISPN-empty;"
    elif int(ispn) > 2 ** 30:
        err_msg += " big ISP-code; "

    if "" == err_msg:
        return True

    sys.stderr.write(">>> NB: %s // row: [%s]\n" % (err_msg, line))
    return False


def data_processor(input):
    for line in input:
        line = line.strip()
        if 0 == len(line) or '#' == line[0]:
            continue

	json_str = line2json(line)
        parsed_line = json.loads(json_str)

        if "isp" not in parsed_line.keys():
            sys.stderr.write(">>> no ISP in [%s]\n" % (json_str))
            continue

        cidr = parsed_line["cidr"]
        ispn = parsed_line["ispn"]

        if not check_data(cidr, ispn, line):
            continue

        net = netaddr.IPNetwork(cidr)
        print "%s\t%s\t%s\t%s\t%d" % (net.first, net.last, ispn, cidr, net.version)


data_processor(sys.stdin)
