#!/bin/sh -E
# NB: run "$ ./this-script verbose" for more detailed intermediate data-structures

script_dir=$(dirname $(readlink -f $0))

verbose_mode=0
if [ 0 -lt ${#1} ]; then
    verbose_mode=1
fi

get_fname() {
    if [ 1 -eq ${verbose_mode} ]; then
        echo "$1"
        return
    fi
    echo "/dev/null"
}

prepare_networks_list() {
    tunnel_6to4_match="=2002:"
    # prepare sorted ranges+isp-codes without dups
    tee $(get_fname .step1.initial_data) \
    | grep -v ${tunnel_6to4_match} \
    | ${script_dir}/cidr2long.py 2> no_isp_prefixes.err \
    | tee $(get_fname .step2.nomarks.beg+end) \
    | sort -k1n -k2nr \
    | tee $(get_fname .step3.sorted) \
    | awk -v F='\t' -vOFS='\t' '{ print $3, $1, $2, $4, $5 }' \
    | uniq -c --skip-fields=1 \
    | tee $(get_fname .step4.uniq_ranges) \
    | awk -v OFS='\t' '{ print $5, $2 }' \
    | tee $(get_fname networks.list)
}

add_fake_ranges() {
    ${script_dir}/add_fake_ranges.py 2> nets_n_fakes.err \
    | tee $(get_fname .step5.nets_n_fakes.list)
}

merge_ranges() {
    ${script_dir}/merge_ranges.py \
    | tee $(get_fname .step6.merged_nets_counted.list) \
    | awk '{ print $1"\t"$2 }' \
    | tee $(get_fname .step7.networks+fake+merge.list)
}

prepare_networks_list \
| add_fake_ranges \
| merge_ranges \
| tee networks_faked_merged.list isp_networks_final.list
