#!/usr/bin/env python

import sys
import netaddr

good_range_beg, good_range_end, good_range_isp = sys.stdin.readline().strip().split('\t')
good_range_count = 1

for line in sys.stdin:
    line = line.strip()
    if 0 == len(line) or '#' == line[0]:
        continue

    curr_range_beg, curr_range_end, curr_range_isp = line.split('\t')

    curr_beg_ip = netaddr.IPAddress(curr_range_beg)
    good_end_ip = netaddr.IPAddress(good_range_end)

    if ((good_end_ip.version == 4 or good_end_ip.is_ipv4_mapped()) and curr_beg_ip.version == 6) \
       or (good_range_isp != curr_range_isp):
        print "%s-%s\t%s\t%d" % (good_range_beg, good_range_end, good_range_isp, good_range_count)
        good_range_beg = curr_range_beg
        good_range_end = curr_range_end
        good_range_isp = curr_range_isp
        good_range_count = 1
        continue

    if (good_end_ip + 1) != curr_beg_ip:
        sys.stderr.write(">>> ERR(net-range):\t%s != %s\n" % (good_end_ip + 1, curr_beg_ip))
        sys.exit(-1)
    if good_range_isp != curr_range_isp:
        sys.stderr.write(">>> ERR(isp-name):\t%s != %s\n" % (good_range_isp, curr_range_isp))
        sys.exit(-2)

    good_range_end = curr_range_end
    good_range_count += 1

print "%s-%s\t%s\t%d" % (good_range_beg, good_range_end, good_range_isp, good_range_count)
