#!/usr/bin/env python

import sys


EARTH_REG_ID = 10000


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--geodata',
                        default="geodata.bin",
                        help="path to geodata.bin")
    parser.add_argument('--root-id',
                        type=int,
                        default=EARTH_REG_ID,
                        help="tree root id")
    parser.add_argument('--check-lings',
                        default="ru,en,uk,be",
                        help="comma separated list of checked langs")
    parser.add_argument('--debug-progress-step',
                        type=int,
                        default=5000,
                        help="print row-numbers; 0 - disable")
    args = parser.parse_args()
    return args


def is_space_value(v, case):
    if v == " ":
        print >>sys.stderr, "FAIL %s" % (case)
        return False

    return True


def check_lings(l, prefix):
    return is_space_value(l.nominative, prefix + "nominative") \
           and is_space_value(l.prepositional, prefix + "prepositional") \
           and is_space_value(l.preposition, prefix + "preposition") \
           and is_space_value(l.genitive, prefix + "genitive") \
           and is_space_value(l.dative, prefix + "dative") \
           and is_space_value(l.locative, prefix + "locative") \
           and is_space_value(l.directional, prefix + "directional") \
           and is_space_value(l.ablative, prefix + "ablative") \
           and is_space_value(l.accusative, prefix + "accusative") \
           and is_space_value(l.instrumental, prefix + "instrumental")


def main(args):
    import geobase6

    print >>sys.stderr, "checking linguistics in [", args.geodata, "] (@see LIB-871)..."
    lookup_geo = geobase6.Lookup(args.geodata)
    all_regs = lookup_geo.get_tree(args.root_id)

    regs_total = 0
    errors_amount = 0

    for reg in all_regs:
        regs_total += 1

        if args.debug_progress_step and (0 == regs_total % args.debug_progress_step):
            print >>sys.stderr, "%d..." % regs_total

        if args.check_lings:
            for lang in args.check_lings.split(','):
                ling_cases = lookup_geo.get_linguistics(reg['id'], lang)
                if not check_lings(ling_cases, "%d/%s/" % (reg['id'], lang)):
                    errors_amount += 1

    print "STATS: %d/%d (total/with-err)\n%s" % (regs_total, errors_amount, "FAIL" if errors_amount else "COMPLETE")
    return errors_amount


if __name__ == "__main__":
    sys.exit(main(parse_args()))
