#!/bin/bash -E
set -aeo pipefail # x

script_dir="$(dirname $(readlink -f $0))"
. ${script_dir}/common.sh

required_debs_list="curl jq wget libgeobase6-python=6.0-37 yandex-yt-python yandex-search-kikimr-yql-client-bin"

build_util_tar_url() {
    local sandbox_base="https://proxy.sandbox.yandex-team.ru"
    local sbr_traits="?owner=IPREG&attrs=%7B%22kind%22:%22borders-section-utils%22%7D"
    echo "${sandbox_base}/last/IPREG_DATA${sbr_traits}"
}

make_borders_section() {
    debug_info
    install_required_debs ${required_debs_list}

    cd ${data_path}
    ${curl_cmd} -OJ "$(build_util_tar_url)"
    tar xvf offline-matching.trunk.tar.gz
    cd offline-matching

    . ${data_path}/tokens.list
    ./__main_cycle__.sh

    if [ ! -d result ]; then
        echo "no result-dir [result]"
        exit 1
    fi

    mv result ${result_fname_path}
    move_result_file_if_required
    debug_info
}

make_borders_section
