#! /usr/bin/env python
# simple checker of borders' window for LIB-713

import sys
import geobase5

lookup = geobase5.Lookup(sys.argv[1])
data_file = sys.argv[2]

window_fields = ["min_lat", "min_lon", "max_lat", "max_lon"]
wrong_data = 0

for line in open(data_file).readlines():
    if not line or line.startswith('#'):
        continue

    splitted_data = line.split('\t')
    reg_id = splitted_data[0]
    try:
        reg_id = int(reg_id)
    except:
        sys.stderr.write("unknown ID in %s\n" % line)
        continue

    reg_data = lookup.region_by_id(reg_id).as_dict
    mistakes = ""

    for i in range(4):
        if reg_data[window_fields[i]] != float(splitted_data[i + 1]):
            wrong_data += 1
            mistakes += "\t@%s(got:%f/want:%s)" % (window_fields[i], reg_data[window_fields[i]], splitted_data[i + 1])

    if len(mistakes):
        sys.stderr.write("%d%s\n" % (reg_id, mistakes))
