#!/usr/bin/env python

import sys


countries_traits = [
      {"country_id": 171, "lang_iso": "uz", "non_empty_cases": [ "nominative", "genitive", "dative", "prepositional" ]}
    , {"country_id": 117, "lang_iso": "lt", "non_empty_cases": [ "nominative", "prepositional" ]}
    , {"country_id": 206, "lang_iso": "lv", "non_empty_cases": [ "nominative", "prepositional" ]}
    , {"country_id": 123, "lang_iso": "fi", "non_empty_cases": [ "nominative", "prepositional" ]}
    , {"country_id": 120, "lang_iso": "pl", "non_empty_cases": [ "nominative", "prepositional" ]}
    , {"country_id": 179, "lang_iso": "et", "non_empty_cases": [ "nominative", "prepositional" ]}
]


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('--geodata',
                        default="geodata.bin",
                        help="path to geodata.bin")
    args = parser.parse_args()
    return args


def check_lings(r, l, checked_cases):
    if r['native_name'] != l.nominative:
        print >>sys.stderr, "native != nominative r#%d/%s\t[%s] != [%s]" % (r['id'], r['name'], r['native_name'], l.nominative)
        return False

    for case_name in checked_cases:
        case_val = getattr(l, case_name)
        if not case_val:
            print >>sys.stderr, "bad %s-value [%s] for r#%d/%s" % (case_name, case_val, r['id'], r['name'])
            return False

    return True


def main(args):
    import geobase6

    print >>sys.stderr, "checking linguistics in [", args.geodata, "]..."
    lookup_geo = geobase6.Lookup(args.geodata)

    regs_qty = 0
    errs_qty = 0
    for country_traits in countries_traits:
        cid = country_traits['country_id']
        cases_list = country_traits['non_empty_cases']

        country_reg = lookup_geo.get_region_by_id(cid)
        main_lang = country_traits['lang_iso']
        if main_lang not in country_reg['official_languages'].split(','):
            raise Exception("which lang in %s?" % country_reg['name'])

        all_regs = lookup_geo.get_tree(cid)

        for reg in all_regs:
            regs_qty += 1
            reg_ling = lookup_geo.get_linguistics(reg['id'], main_lang)
            if not check_lings(reg, reg_ling, cases_list):
                errs_qty += 1

    print "STATS: %d/%d (total/with-err)\n%s" % (regs_qty, errs_qty, "FAIL" if errs_qty else "COMPLETE")
    return errs_qty


if __name__ == "__main__":
    sys.exit(main(parse_args()))
