#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import geobase6


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('-g', '--geodata', default="geodata.bin", help="path to geodata")
    parser.add_argument('-f', '--field-name', default="", help="field name for id extraction, if value OK")
    args = parser.parse_args()
    return args


def main(args):
    lookup = geobase6.Lookup(args.geodata)

    EARTH_ID = 10000
    for reg in lookup.get_tree(EARTH_ID):
        if reg[args.field_name]:
            print reg['id']

    return 0


if __name__ == "__main__":
    sys.exit(main(parse_args()))
