#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import geobase6


EU_LIST = {
    113:  	["Австрия", "AT"],
    114:  	["Бельгия", "BE"],
    115:  	["Болгария", "BG"],
    102:  	["Великобритания", "GB"],
    116:  	["Венгрия", "HU"],
    96:   	["Германия", "DE"],
    246:  	["Греция", "GR"],
    203:  	["Дания", "DK"],
    10063:	["Ирландия", "IE"],
    10064:	["Исландия", "IS"],
    204:  	["Испания", "ES"],
    205:  	["Италия", "IT"],
    20574:	["Кипр", "CY"],
    206:  	["Латвия", "LV"],
    117:  	["Литва", "LT"],
    10067:	["Лихтенштейн", "LI"],
    21203:	["Люксембург", "LU"],
    10069:	["Мальта", "MT"],
    118:  	["Нидерланды", "NL"],
    119:  	["Норвегия", "NO"],
    120:  	["Польша", "PL"],
    10074:	["Португалия", "PT"],
    10077:	["Румыния", "RO"],
    121:  	["Словакия", "SK"],
    122:  	["Словения", "SI"],
    123:  	["Финляндия", "FI"],
    124:  	["Франция", "FR"],
    10083:	["Хорватия", "HR"],
    125:  	["Чехия", "CZ"],
    126:  	["Швейцария", "CH"],
    127:  	["Швеция", "SE"],
    179:  	["Эстония", "EE"]
}


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('-g', '--geodata',
                        default="",
                        help="path to 'geodata.bin'")
    args = parser.parse_args()
    return args


def build_by_geodata(geodata):
    lookup = geobase6.Lookup(geodata)

    eu_regs_only = {}
    for eu_country_id in EU_LIST.keys():
        country_full_tree = lookup.get_tree(eu_country_id)
        regs = { r['id']: r['name'] for r in country_full_tree}
        eu_regs_only.update(regs)

    return eu_regs_only


def parse_ipreg(stream, good_ids):
    line_num = 0
    for line in stream:
        line_num += 1
        line = line.strip()

        parts = line.split('\t')
        if len(parts) != 2:
            raise Exception("bad cols qty #%d; row#%d - %s" % (len(parts), line_num, line))

        try:
            traits = json.loads(parts[1])
            if traits['region_id'] in good_ids:
                print line
        except Exception as ex:
            raise Exception("ERROR in row#%d - [%s]; data: %s" % (line_num, str(ex), line))


def main(args):
    eu_regs_only = build_by_geodata(args.geodata)
    parse_ipreg(sys.stdin, eu_regs_only)
    return 0


if __name__ == "__main__":
    sys.exit(main(parse_args()))
