#!/bin/bash -E
set -aeo pipefail # x

script_dir="$(dirname $(readlink -f $0))"
. ${script_dir}/common.sh

get_generator_deb() {
    case $db_kind in
        psql)  echo "geobase6-generator=6.0-35"
               return
               ;;
    esac

    echo "$FUNCNAME >>> unknown db_kind ${db_kind}"
    exit 1
}

geodata_format="5.0.0"
required_debs_list="$(get_generator_deb) curl yandex-internal-root-ca geobase5-checker=5.3-14 geobase5-utils=5.3-14 libgeobase5-python=5.3-14 libgeobase6-python=6.0-35 python-ipaddr python-netaddr yandex-yt-python awscli"
geogen_tool="/opt/yandex/geobase/geobase6-generator"

geobin_datafile="${data_path}/geodata5.bin"

borders_file="reverse_borders_world.bin"
borders_datafile="${data_path}/${borders_file}"
borders_datafile_src_url="NB: should be specified on upper level"

prepare_assets() {
    echo "assets download [${asdata_src}]..."
    get_assets \
    > $assets_datafile

    wc -l $assets_datafile
}

check_resources() {
    echo $FUNCNAME
    check_basic_resources
    check_additional_resources
    check_file ${eu_regions_fname} 7000
}

build() {
    debug_info
    view_remote_content
    install_required_debs ${required_debs_list}
    check_awscli

    prepare_eu_list
    prepare_assets
    download_ipregs
    download_tor
    download_isp
    download_borders_section
    check_resources

    generate_geodata5_bin "--new-fields-data=${eu_regions_fname}"
    check_geodata_bin
    test_geodata_bin
    test_geodata5_bin
    check_eu_list

    move_result_file_if_required
    upload_s3mds
}
