#!/bin/bash -E
set -aeo pipefail

script_dir="$(dirname $(readlink -f $0))"
. ${script_dir}/geodata5-common.sh

geobin_datafile="${data_path}/geodata5-xurma.bin"

generate_geodata5_xurma() {
    echo $FUNCNAME

    . ${db_traits_datafile}

    echo "'${geobin_datafile}' generation..."
    $geogen_tool \
        $geodata_check_flag \
        --format=$(echo $geodata_format | tr -d '.') \
        --output=$geobin_datafile \
        --regions-section=@DB \
        --fields-list=id,type,parent_id,geo_parent_id,capital_id,latitude,longitude,name,services \
        --dbhost=$db_host \
        --dbuser=$db_user \
        --dbpass="${db_pswd}" \
        --dbport=$db_port \
        --dbname=$db_name
}

check_xurma_bin() {
    echo $FUNCNAME

    check_file ${geobin_datafile}
    $geocheck_tool $geobin_datafile
    $geoutils_tool -i -f $geobin_datafile
    check_dangling_regions
}

build_xurma() {
    debug_info
    install_required_debs ${required_debs_list} # NB: 6.0-17+ from geodata5-common.sh will enough

    generate_geodata5_xurma
    check_xurma_bin

    move_result_file_if_required
}

build_xurma
