#!/bin/bash -E
set -aeo pipefail

script_dir="$(dirname $(readlink -f $0))"
. ${script_dir}/geodata6-common.sh

geobin_datafile="${data_path}/geodata6-balancer.bin"

generate_geodata6_balancer() {
    echo $FUNCNAME

    . ${db_traits_datafile}

    echo "'${geobin_datafile}' generation..."
    $geogen_tool \
        $geodata_check_flag \
        --format=$(echo $geodata_format | tr -d '.') \
        --output=$geobin_datafile \
        --regions-section=@DB \
        --fields-list=id,type,parent_id,geo_parent_id,capital_id,latitude,longitude,name,services \
        --dbhost=$db_host \
        --dbuser=$db_user \
        --dbpass="${db_pswd}" \
        --dbport=$db_port \
        --dbname=$db_name \
        --as-section ${data_path}/IPREG-as.patch.list \
        --isp-names-section ${data_path}/IPREG-mmisp.patch.names \
        --ip-traits-section ${data_path}/IPREG-traits.list \
        --ipreg-section ${data_path}/IPREG.final
}

make_stub_data() {
    touch ${data_path}/IPREG-traits.list

    echo "0" > ${data_path}/IPREG-as.patch.list
    echo -e "1\tcloudflare\t0\t0" > ${data_path}/IPREG-mmisp.patch.names
}

check_balancer_resources() {
    echo $FUNCNAME

    check_file ${data_path}/GeoIP2-Anonymous-IP-Blocks-IP46.csv 120000
    check_file ${data_path}/IPREG-traits.list 5000
    check_file ${data_path}/IPREG.json_wo_reliabilities 2000000
    check_file ${data_path}/IPREG.final 2000000
    check_file ${data_path}/IPREG-as.patch.list 1
    check_file ${data_path}/IPREG-mmisp.patch.names 1
}

check_balancer_bin() {
    echo $FUNCNAME

    check_file ${geobin_datafile}
    $geocheck_tool $geobin_datafile
    $geoutils_tool -i -f $geobin_datafile
    check_dangling_regions
    test_ipreg_data --json-traits
}

build_balancer_bin() {
    debug_info
    view_remote_content
    install_required_debs ${required_debs_list} # NB: geobase6-generator=6.0-31 from geodata6-common.sh will enough

    ${script_dir}/prepare_full_patch.sh ${data_path} eu_only
    make_stub_data
    check_balancer_resources

    generate_geodata6_balancer
    check_balancer_bin

    move_result_file_if_required
}

build_balancer_bin
