#!/bin/bash -E
set -aeo pipefail

script_dir="$(dirname $(readlink -f $0))"
. ${script_dir}/geodata6-common.sh

generate_geodata6_cutted() {
    echo $FUNCNAME

    . ${db_traits_datafile}

    echo "'${geobin_datafile}' generation..."
    $geogen_tool \
        $geodata_check_flag \
        --format=$(echo $geodata_format | tr -d '.') \
        --output=$geobin_datafile \
        --regions-section=@DB \
        --fields-list=id,type,parent_id,geo_parent_id,capital_id,latitude,longitude,name,services \
        --dbhost=$db_host \
        --dbuser=$db_user \
        --dbpass="${db_pswd}" \
        --dbport=$db_port \
        --dbname=$db_name \
        --as-section ${data_path}/IPREG-as.patch.list \
        --isp-names-section ${data_path}/IPREG-mmisp.patch.names \
        --ip-traits-section ${data_path}/IPREG-traits.list \
        --ipreg-section ${data_path}/IPREG.final \
        $*
}

check_cutted6_bin() {
    echo $FUNCNAME

    check_file ${geobin_datafile}
    $geocheck_tool $geobin_datafile
    $geoutils_tool -i -f $geobin_datafile
    check_eu_list
    check_dangling_regions
    test_ipreg_data
}

build_cutted() {
    debug_info
    view_remote_content
    install_required_debs ${required_debs_list} # NB: geobase6-generator=6.0-31 from geodata6-common.sh will enough

    ${script_dir}/prepare_full_patch.sh ${data_path} yandex
    prepare_eu_list
    check_resources

    generate_geodata6_cutted "--new-fields-data=${eu_regions_fname}"
    check_cutted6_bin

    move_result_file_if_required
}
