#!/bin/bash -E
set -aeo pipefail # x

script_dir="$(dirname $(readlink -f $0))"
. ${script_dir}/common.sh

get_xenial_pg_source() {
    cat <<- EOF_XENIAL
	# v.10 is required
	deb http://apt.postgresql.org/pub/repos/apt/ xenial-pgdg main
	EOF_XENIAL
}

add_pg_apt_sources() {
    get_xenial_pg_source > pgdg.list
    sudo cp pgdg.list /etc/apt/sources.list.d/
}

required_debs_list="--allow-unauthenticated postgresql-client yandex-internal-root-ca"

geobin_datafile="${data_path}/$(date +%Y%m%d.%H%M).geodb.psql.dump"
geobin_datafile_targz="${data_path}/geodb.tar.gz"

make_backup_copy() {
    debug_info

    add_pg_apt_sources
    install_required_debs ${required_debs_list}

    . ${db_traits_datafile}
    local db_conn_str="user=${db_user} password=${db_pswd} host=${db_host} dbname=${db_name} port=${db_port} sslmode=verify-full sslrootcert=/etc/ssl/certs/YandexInternalRootCA.pem"

    pg_dump \
        "${db_conn_str}" \
        --schema=${db_name} \
        --exclude-schema=public \
        --format=c \
        --compress=9 \
        --clean \
        --if-exists \
        --file=${geobin_datafile} \
        --verbose

    check_file ${geobin_datafile}
    generate_targz
    move_result_file_if_required
}

make_backup_copy
