#!/usr/bin/env python
# -*- coding: utf-8 -*-

# based on
# https://a.yandex-team.ru/arc//trunk/arcadia/ipreg/geogenerator/bin/bgp/split_ranges.py?rev=3421085
#
# actually, doing the same as
# https://a.yandex-team.ru/arc//trunk/arcadia/sandbox/projects/geobase/common/gen_layout.py?rev=3609964#L38-62
#
# USAGE
# $ cat ${racktable-export} \
#   | ./ipreg-fmt --empty-data --add-json-attr ${yandex-datakind-mark} \
#   | sort \
#   | ./ipreg-merge \
#   | ./merge_ranges.py | tee aggr-merge.1 | wc -l
#
# TODO(dieash@)
# maybe include into `ipreg-merge`-util

import ipaddr
import sys


class Range(object):
    def __init__(self, begin, end, data):
        self.begin = begin
        self.end = end
        self.data = data

    def to_string(self):
        return "%s-%s\t%s" % (self.begin.exploded, self.end.exploded, self.data)

    def __repr__(self):
        return self.to_string()

    def in_range(self, outer):
        return outer and self.begin >= outer.begin and self.end <= outer.end

    @staticmethod
    def load_from_string(line):
        begin, end, data = line.strip().replace('-', '\t').split('\t')
        return Range(ipaddr.IPAddress(begin), ipaddr.IPAddress(end), data)

    @staticmethod
    def load_from_stream(stream):
        for line in stream:
            return Range.load_from_string(line)
        return None


def parse_args():
    return None


def print_range(r):
    if r:
        print r


def do(args):
    curr_range = None
    previous_range = None

    while True:
        curr_range = Range.load_from_stream(sys.stdin)
        if not curr_range:
            break

        if not previous_range or previous_range.end < curr_range.begin:
            print_range(previous_range)
            previous_range = curr_range
            continue

        if curr_range.begin < previous_range.begin:
            raise Exception("WRONG ORDER prev[%s] after curr[%s]" % (previous_range, curr_range))

        if curr_range.in_range(previous_range):
            continue

        if not previous_range.in_range(curr_range):
            raise Exception("WRONG RANGES prev[%s] and curr[%s]" % (previous_range, curr_range))

        previous_range = curr_range

    print_range(previous_range)
    return 0


if __name__ == "__main__":
    sys.exit(do(parse_args()))
