#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import geobase6


EU_LIST = {
    113:  	["Австрия", "AT"],
    114:  	["Бельгия", "BE"],
    115:  	["Болгария", "BG"],
    102:  	["Великобритания", "GB"],
    116:  	["Венгрия", "HU"],
    96:   	["Германия", "DE"],
    246:  	["Греция", "GR"],
    203:  	["Дания", "DK"],
    10063:	["Ирландия", "IE"],
    10064:	["Исландия", "IS"],
    204:  	["Испания", "ES"],
    205:  	["Италия", "IT"],
    20574:	["Кипр", "CY"],
    206:  	["Латвия", "LV"],
    117:  	["Литва", "LT"],
    10067:	["Лихтенштейн", "LI"],
    21203:	["Люксембург", "LU"],
    10069:	["Мальта", "MT"],
    118:  	["Нидерланды", "NL"],
    119:  	["Норвегия", "NO"],
    120:  	["Польша", "PL"],
    10074:	["Португалия", "PT"],
    10077:	["Румыния", "RO"],
    121:  	["Словакия", "SK"],
    122:  	["Словения", "SI"],
    123:  	["Финляндия", "FI"],
    124:  	["Франция", "FR"],
    10083:	["Хорватия", "HR"],
    125:  	["Чехия", "CZ"],
    126:  	["Швейцария", "CH"],
    127:  	["Швеция", "SE"],
    179:  	["Эстония", "EE"]
}


def parse_args():
    import argparse
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument('-g', '--geodata',
                        default="",
                        help="path to 'geodata.bin'")
    parser.add_argument('-e', '--export-data',
                        default="-",
                        help="path to export output; use '-' for stdin; format {$country_id,$reg_id}; http://geoexport.yandex.ru/?types=_all_&fields=country_id,id")
    args = parser.parse_args()
    return args


def build_by_geodata(geodata):
    lookup = geobase6.Lookup(geodata)

    for eu_country_id in EU_LIST.keys():
        country_full_tree = lookup.get_tree(eu_country_id)

        print "#%d\t%s\t%s" % (eu_country_id, EU_LIST[eu_country_id][1], EU_LIST[eu_country_id][0])
        for reg in country_full_tree:
            print "%s\t%d" % (reg['id'], True)


def parse_export(stream):
    for line in stream:
        parts = line.strip().replace(',', '\t').replace(' ', '\t').split('\t')
        if not parts or len(parts) < 2 or not parts[0].isdigit():
            continue

        country_id = int(parts[0])
        region_id = int(parts[1])

        if country_id not in EU_LIST.keys():
            continue

        print "%s\t%d" % (region_id, True)


def main(args):
    print "#@desc\tis_eu@bool"

    if args.geodata:
        build_by_geodata(args.geodata)
    else:
        data_input = sys.stdin if '-' == args.export_data else open(args.export_data, 'r')
        parse_export(data_input)

    return 0


if __name__ == "__main__":
    sys.exit(main(parse_args()))
