#!/usr/bin/env python
# -*- coding: utf-8 -*-

# build helpers

import os.path
import ssl
import urllib2
import sys

from utils_proj_nets import stream_processing


def get_url_data(url, secure=False):
    context = ssl.create_default_context()
    if not secure:
        context.check_hostname = False
        context.verify_mode = ssl.CERT_NONE

    try:
        ret = urllib2.urlopen(url, data=None, context=context)
        return ret
    except Exception as ex:
        raise Exception("[%s] => %s" % (url, ex))


def download_and_save(url, save_as):
    with open(save_as, "w") as local_file:
        stream_processing(get_url_data(url), local_file, save_as)
        local_file.close()


def extract_column_1(url):
    data = get_url_data(url)
    result = []

    for line in data:
        parts = line.strip().split()
        result.append(parts[0])

    return result


RACK_TABLE_BASE = "https://racktables.yandex.net/export"


def build_racktable_request(ip_kind, report_name):
    NETWORKS_EXPORT_URL = RACK_TABLE_BASE + "/networklist.php"

    return "%s?only=%s&report=%s" % (NETWORKS_EXPORT_URL, ip_kind, report_name)


def load_data_from_sources(sources_urls, fname):
    with open(fname, "w") as local_file:
        for url in sources_urls:
            for item in extract_column_1(url):
                print >>local_file, item
        local_file.close()


def save_nets_to_file(nets_list, fname):
    with open(fname, "w") as local_file:
        for net in nets_list:
            print >>local_file, net
        local_file.close()


def load_nets_from_file(fname):
    nets_list = []

    for line in open(fname):
        nets_list.append(line.strip())

    return nets_list


def find_and_remove_useless(checked_nets_fname, ya_nets_fname, result_fname):
    checked_nets = load_nets_from_file(checked_nets_fname)
    ya_nets = load_nets_from_file(ya_nets_fname)

    final_checked_nets = [x for x in checked_nets if x in ya_nets]
    save_nets_to_file(final_checked_nets, result_fname)


def check_file(fname, min_size):
    if not os.path.exists(fname):
        raise Exception("no file [%s]" % fname)

    fsize = os.path.getsize(fname)
    if fsize < min_size:
        raise Exception("file too small [%s / %s]" % (fname, fsize))
