{%- macro color_print(value, signification) -%}
    {%- if signification == "LIGHT_RED" -%}
        {%- set text_color = "pink" -%}
    {%- elif signification == "LIGHT_GREEN" -%}
        {%- set text_color = "lightgreen" -%}
    {%- elif signification == "NONE" -%}
        {%- set text_color = "gray" -%}
    {%- else -%}
        {%- set text_color = signification.lower() -%}
    {%- endif -%}
    {%- if value is number -%}
<#<a style="color: {{ text_color }}; font-weight: bold;">{{ "%2.2f" %  value }}</a>#>
    {%- else -%}
<#<a style="color: {{ text_color }}; font-weight: bold;">{{ value }}</a>#>
    {%- endif -%}
{%- endmacro -%}

{%- macro print_basket(basket, type, count) -%}
{% if basket.get(type)|length -%}
{% if basket.get(count) -%}
|| ========{{ basket.get('name') }} ||
{%- for metric in basket.get(type) -%}
|| {{ metric.get('name') }} | {{ color_print(metric.get('diff_percent'), metric.get('signification')) }} ||
{%- endfor -%}
{%- endif %}
{%- endif %}
{%- endmacro -%}

{%- macro print_launch(launch, type, count) -%}
{% if launch.get(count) -%}
|| ======{{ launch.get('name') }} ||
{% for basket in launch.get('baskets') -%}
{{ print_basket(basket, type, count) }}
{%- endfor %}
{%- endif %}
{%- endmacro -%}

====(({{ url.replace('api/launch-set', 'sets') }} {{ name }}))
{% if changed_perc > changed_critical_perc -%}
=====!!(red)Прокрасилось {{ changed_perc }}% метрик!!
=====!!(red)Максимально допустимый процент прокрашенных метрик - {{ changed_critical_perc }}%!!
{% endif -%}
#|
{% if bad_count -%}
|| =====!!(red)Критичные и важные метрики!! ||
{% for launch in launches -%}
{{ print_launch(launch, 'bad_metrics', 'bad_count') }}
{%- endfor -%}
{%- endif -%}
{% if colored_count -%}
{% if bad_count -%}
|| =====!!(gray)Так же прокрасились!! ||
{%- else -%}
|| =====!!(gray)Прокрасились следующие метрики!! ||
{%- endif -%}
{% for launch in launches -%}
{{ print_launch(launch, 'colored_metrics', 'colored_count') }}
{%- endfor -%}
{%- endif -%}
|#
