{% macro print_failed_scenario_details(dtls) -%}
{% if dtls is string %}
{# plain text #}
{% for line in dtls.splitlines() %}
{{ line }}
{% endfor %}
{% else %}
{# structured report #}
{% if dtls.steps %}
<[{% for step in dtls.steps %}
{% if step.failed %}!!(red){% endif %}{{ step.keyword }} {{ step.name }}{% if step.failed %}!!{% endif %}{% endfor %}
]>
{% endif %}
{% if dtls.traceback %}
%%{{ dtls.traceback }}%%
{% endif %}
{% if dtls.links %}
{% for link in dtls.links %}
(({{ link.url }} {{ link.name }})){% endfor %}
{% endif %}
{% endif %}
{%- endmacro %}
{% for launch_set in launch_sets -%}
{{ launch_set }}
{% endfor %}
{% if marker_data|length %}
===Дифф в маркерных тестах
{% for scenario, dtls in marker_data.iteritems()|sort %}
<{ {{ scenario }}
{#{{ print_failed_scenario_details(dtls) }}#}
}>
{% endfor %}
{% endif %}
{% if perf_data|length -%}
===Результаты перф-тестов
#|
||
    **Parameter** |
    **Reference** |
    **Test** |
    **Difference** |
    **Percent**
    ||
{% for key, value in perf_data.iteritems() -%}
||
    **{{ key }}** |
    {{ "%2.3f" % value.reference }} |
    {{ "%2.3f" % value.test }} |
    {{ "%2.3f" % value.difference }} |
    {% if key not in ["rps"] %}
    {% if value.percent > 0.0 %}
    !!(red){{ "%+2.3f%%" % value.percent}}!!
    {% elif value.percent < 0.0 %}
    !!(green){{ "%+2.3f%%" % value.percent}}!!
    {% else %}
    {{ "%+2.3f%%" % value.percent}}
    {% endif %}
    {% else %}
    {{ "%+2.3f%%" % value.percent}}
    {% endif %}
    ||
{%- endfor -%}
|#
{%- endif -%}
