# -*- coding: utf-8 -*-

from sandbox.projects import BuildDynamicModels
from sandbox.projects.common.dynamic_models.compare import generate_diff_footer
from sandbox.projects.common.nanny import nanny

from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter


class ModelsUrlForProduction(SandboxSvnUrlParameter):
    """
        SVN URL для продакшн формул
    """
    name = 'models_svn_url_production'
    description = 'production models svn url (get latest released if empty)'
    default_value = 'arcadia:/arc/trunk/arcadia/extsearch/geo/base/formula/mxnet_formulas'
    required = False


class ModelsUrlForExperiment(SandboxSvnUrlParameter):
    """
        SVN URL для экспериментальных формул
    """
    name = 'models_svn_url_experiment'
    description = 'experiment models svn url (get latest if empty)'
    default_value = None
    required = False


# class CheckProductionModelsList(SandboxBoolParameter):
#     name = 'check_production_models_list'
#     description = 'Check that production models contain Hast, Wizard and fast models'
#     default_value = False


class StrictFormulaIdChecks(SandboxBoolParameter):
    name = 'strict_check_formula_id'
    description = 'Checks that all formulas contain ID and throws exception if true.'
    default_value = False


class ModelsCustom(SandboxBoolParameter):
    name = 'custom_models'
    description = 'add custom models from svn'
    default_value = False


class FailWithoutSlices(SandboxBoolParameter):
    name = 'fail_without_slices'
    description = 'fail if formula without slices'
    default_value = False


class AddrsBuildDynamicModels(BuildDynamicModels.BuildDynamicModels, nanny.ReleaseToNannyTask):
    """
        Таск выкачивает модели из SVN по указанному URL
        и собирает их в архив с помощью tools/archiver.

        Использует таск BuildDynamicModels как основу.
    """

    type = 'ADDRS_BUILD_DYNAMIC_MODELS'

    description = 'Dynamic models archive for geosearch'

    archive_name = 'geosearch_models.archive'

    resourse_type = resource_types.ADDRS_DYNAMIC_MODELS_ARCHIVE

    input_parameters = (
        BuildDynamicModels.ModelsForProduction,
        ModelsUrlForProduction,
        BuildDynamicModels.ModelsForExperiment,
        ModelsUrlForExperiment,
        # CheckProductionModelsList,
        StrictFormulaIdChecks,
        ModelsCustom,
        FailWithoutSlices,
    )

    def get_resource_type(self):
        return 'ADDRS_DYNAMIC_MODELS_ARCHIVE'

    def filter_models(self, files):
        return files

    @property
    def footer(self):
        return generate_diff_footer(self.ctx.get('diff'))


__Task__ = AddrsBuildDynamicModels
