{% macro print_failed_scenario_details(dtls) -%}
{% if dtls is string %}
{# plain text #}
{% for line in dtls.splitlines() %}
{{ line }}
{% endfor %}
{% else %}
{# structured report #}
{% if dtls.steps %}
<[{% for step in dtls.steps %}
{% if step.failed %}!!(red){% endif %}{{ step.keyword }} {{ step.name }}{% if step.failed %}!!{% endif %}{% endfor %}
]>
{% endif %}
{% if dtls.traceback %}
%%{{ dtls.traceback }}%%
{% endif %}
{% if dtls.links %}
{% for link in dtls.links %}
(({{ link.url }} {{ link.name }})){% endfor %}
{% endif %}
{% endif %}
{%- endmacro %}

{% if diff is defined %}
===Разница между {{ ref.split('/yandsearch')[0] }} и {{ test.split('/yandsearch')[0] }}
{% for scenario, dtls in diff.iteritems()|sort %}
<{ {{ scenario }}
{{ print_failed_scenario_details(dtls) }}
}>
{% endfor %}
{% else %}
=== Нет новых упавших маркерных тестов
{% endif %}

{% if test_details is defined %}
{% if test_details.stats is defined %}
=====Результаты работы ((https://sandbox.yandex-team.ru/task/{{ task_id }}/view ADDRS_MAPKIT_ACCEPTANCE)) (принимаемая база)
{{ test_details.stats.features[0] }}
{{ test_details.stats.scenarios[0] }}
{{ test_details.stats.steps[0] }}
{% endif %}
{% if test_details.details is defined %}
Failed scenarios
{% for scenario, dtls in test_details.details.iteritems()|sort %}
<{ {{ scenario }}
{{ print_failed_scenario_details(dtls) }}
}>
{% endfor %}
{% endif %}
{% endif %}
