# -*- coding: utf-8 -*-
import logging
import shutil

from sandbox import sdk2

from sandbox.projects.geosearch import resource_types as geo_types
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.task_env import TinyRequirements


class AddrsPackUrlTries(sdk2.Task, nanny.ReleaseToNannyTask2):
    """
        Pack url tries resources into one resurce and release it to nanny
    """

    class Parameters(sdk2.Task.Parameters):
        trie_names = sdk2.parameters.String("Trie names (comma separated)", required=True)

    class Requirements(TinyRequirements):
        pass

    def on_execute(self):
        packed_tries_res = geo_types.GEOSEARCH_PACKED_URL_TRIES(self, "Packed url tries", "url_tries", ttl=14)
        packed_tries_data = sdk2.ResourceData(packed_tries_res)
        packed_tries_data.path.mkdir(parents=True, exist_ok=True)

        for trie_name in self.Parameters.trie_names.split(','):
            if len(trie_name) == 0:
                continue

            attrs = {
                'trie_name': trie_name
            }
            trie_res = sdk2.Resource.find(type="SPRAV_SAFESEARCH_DATA", attrs=attrs).first()
            if trie_res is None:
                logging.info("Trie with name {} not found".format(trie_name))
                continue
            trie_data = sdk2.ResourceData(trie_res)
            shutil.copyfile(str(trie_data.path), str(packed_tries_data.path.joinpath(trie_name)))

        packed_tries_data.ready()
