# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.sdk2.helpers import subprocess
from sandbox.projects.geosearch import resource_types as geo_types

import datetime
import os


class AddrsUpdateCpuStat(sdk2.Task):
    """
        Upload cpu stat for previous day to statface report
    """

    class Parameters(sdk2.Task.Parameters):
        cluster = sdk2.parameters.String("YT cluster", default='hahn', required=True)
        collector = sdk2.parameters.Resource(
            'Stat collector',
            resource_type=geo_types.GEOSEARCH_CPU_STAT_COLLECTOR,
            required=True
        )
        logs_dir = sdk2.parameters.String("Logfeller dir with cpu stat log",
                                          default="//home/logfeller/logs/geosearch-cpu-usage-log/1d",
                                          required=True)
        output_table = sdk2.parameters.String("Table with processed cpu stat for upload",
                                              default="//home/geosearch/yu-semichev/cpu_stat",
                                              required=True)
        aggregation_keys = sdk2.parameters.String(
            "Comma separated list with cpu_stat aggregation keys (tvm-<TVM id> or origin-<origin>)",
            required=False)

        scale = sdk2.parameters.String("Aggregation scale", default="continual")

        report_path = sdk2.parameters.String(
            "Path to stat report",
            default="Maps_Plus_Beta/Geosearch/cpu_stat",
            required=True)

        in_cpu_cores = sdk2.parameters.Bool(
            "Collect stat in cpu cores (instead of percent of total cpu time)",
            default=False,
            required=True)

        reduce_stat_method = sdk2.parameters.String(
            'Choose how mesurements will reduced by scaled timestamp. Choose from: "mean", "max"',
            default="mean",
            required=True)

    class Requirements(sdk2.Requirements):
        client_tags = (ctc.Tag.LINUX_PRECISE | ctc.Tag.LINUX_TRUSTY)

    def on_execute(self):
        collector_binary = str(sdk2.ResourceData(self.Parameters.collector).path)

        yt_token = sdk2.Vault.data('GEOMETA-SEARCH', 'yt-token')
        stat_token = sdk2.Vault.data('GEOMETA-SEARCH', 'GEOSEARCH_STAT_TOKEN')

        today = datetime.datetime.now()
        yesterday = today - datetime.timedelta(days=1)

        cmd = [
            collector_binary,
            "--cluster", self.Parameters.cluster,
            "--stat-tables-dir", self.Parameters.logs_dir,
            "--output-table", self.Parameters.output_table,
            "--from", yesterday.strftime('%Y-%m-%d 00:00:00+03'),
            "--to", today.strftime('%Y-%m-%d 00:00:00+03'),
            "--aggregation-keys", self.Parameters.aggregation_keys,
            "--stat-token", stat_token,
            "--scale", self.Parameters.scale,
            "--report", self.Parameters.report_path,
            "--with-cores-usage", "1" if self.Parameters.in_cpu_cores else "0",
            "--reduce-method", self.Parameters.reduce_stat_method
        ]

        os.environ['MR_RUNTIME'] = 'YT'
        os.environ['YT_TOKEN'] = yt_token

        subprocess.check_call(cmd)
