# -*- coding: utf-8 -*
import os
import time
import datetime
from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.geosearch.tools import nirvana
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
import sandbox.common.types.task as ctt


def get_date():
    return datetime.datetime.now().strftime('%Y-%m-%d %H:%M')


class BuildAddrsAnnotations(sdk2.Task):
    '''
        Launch geostream conveyor
    '''

    class Parameters(sdk2.task.Parameters):
        kill_timeout = 86400
        reference_workflow = sdk2.parameters.String('Reference workflow id', required=True, default_value='')
        export_path = sdk2.parameters.String('Export path', required=True, default_value='//home/altay/db/export/current-state/snapshot')

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        environments = (environments.PipEnvironment('yandex-yt'),)
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name="BuildAddrsAnnotationsSemaphor", weight=1, capacity=2)
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH)
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    @sdk2.header()
    def head(self):
        return '<a href="{url}">{url}</a>'.format(url='https://nirvana.yandex-team.ru/flow/%s/graph' % self.Context.new_workflow) if self.Context.new_workflow else ''

    def on_execute(self):
        proc_env = os.environ.copy()
        yt_token = sdk2.Vault.data('GEOMETA-SEARCH', 'yt-token')
        proc_env['YT_TOKEN'] = yt_token
        nirvana_token = sdk2.Vault.data('robot-geosearch-prod', 'robot_geosearch_prod_sandbox_nirvana_api_token')
        nirvana_cli = nirvana.Nirvana(nirvana_token)

        if not self.Context.new_workflow:
            self.Context.new_workflow = nirvana_cli.clone_workflow(self.Parameters.reference_workflow, 'Stream conveyor production %s' % get_date(), 'Stream conveyor production %s' % get_date())
            nirvana_cli.set_workflow_parameters(
                self.Context.new_workflow,
                [
                    {'parameter': 'timestamp', 'value': int(time.time())},
                    {'parameter': 'export_path', 'value': self.Parameters.export_path},
                ]
            )
            nirvana_cli.start_workflow(self.Context.new_workflow)
            raise sdk2.WaitTime(5 * 60)

        if nirvana_cli.get_workflow_state(self.Context.new_workflow)['status'] != 'completed':
            raise sdk2.WaitTime(1 * 60)

        if nirvana_cli.get_workflow_state(self.Context.new_workflow)['result'] == 'failure':
            nirvana_msg = nirvana_cli.get_workflow_state(self.Context.new_workflow)['message']
            msg = ('Workflow <a href="https://nirvana.yandex-team.ru/flow/'
                   '{workflow_id}/graph">{workflow_id}</a> failed: '
                   '{workflow_err}')
            raise SandboxTaskFailureError(msg.format(workflow_id=self.Context.new_workflow,
                                                     workflow_err=nirvana_msg))
