# coding: utf-8

import logging
from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.projects import resource_types
import sandbox.common.types.notification as ctn
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.projects.geosearch import resource_types as geo_types
from sandbox.projects.UpdateMapsWizardPpoData import UpdateMapsWizardPpoData


class BuildAddrsBaseAdditionalResources(sdk2.Task):
    '''Task for load testing addrs services'''

    class Parameters(sdk2.task.Parameters):
        company_table_path = sdk2.parameters.String('Company table path',
                                                    required=True)
        tables_for_wizard_data = sdk2.parameters.String('Tables for wizard data path',
                                                        required=True)
        fast_features_path = sdk2.parameters.String('YT path to features2_fast.xml.gz',
                                                    required=True)

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def _make_dummy(self):
        path = './dummy.txt'
        open(path, 'a').close()
        return path

    def on_release(self, params):
        sdk2.Task.on_release(self, params)
        for subtask in self.find(status=ctt.Status.Group.SUCCEED):
            self.server.release(task_id=subtask.id,
                                type=params['release_status'],
                                subject=params['release_subject'],
                                comments=params['release_comments'])

    def on_execute(self):
        self.addressees = ['yurakura']
        self.bad_statuses = ['FAILURE',
                             'EXCEPTION',
                             'TIMEOUT']
        with self.memoize_stage.build_wizard_data:
            if not self.Context.build_wizard_data_task:
                ppo_gzt_builder = sdk2.Resource[geo_types.GZT_BUILDER].find(attrs={'released': 'stable'}).first()
                build_wizard_data_task_class = sdk2.Task[UpdateMapsWizardPpoData.type]
                build_wizard_data_task = build_wizard_data_task_class(self,
                                                                      description='Build PPO wizard data',
                                                                      arcadia_url='arcadia:/arc/trunk/arcadia',
                                                                      target=self.Parameters.tables_for_wizard_data,
                                                                      fast_features=self.Parameters.fast_features_path,
                                                                      owner=self.owner,
                                                                      ppo_gzt_builder=ppo_gzt_builder.id,
                                                                      create_sub_task=True,
                                                                      rubric_synonym_priority='//home/geosearch/yu-semichev/rubric_synonym_priority',
                                                                      notifications=sdk2.Notification(tuple(self.bad_statuses),
                                                                                                            self.addressees,
                                                                                                            ctn.Transport.EMAIL))
                build_wizard_data_task.enqueue()
                self.Context.build_wizard_data_task = build_wizard_data_task.id
                raise sdk2.WaitTask([self.Context.build_wizard_data_task],
                                    ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                                    wait_all=True)
            else:
                task = sdk2.Task[self.Context.build_wizard_data_task]
                if task.status in self.bad_statuses:
                    raise SandboxTaskFailureError('Building wizard_data failed')
        build_wizard_data_task = sdk2.Task[self.Context.build_wizard_data_task]
        logging.info('Build wizard data task: %s' % build_wizard_data_task)
        wizard_data_resource = sdk2.Resource[resource_types.MAPS_DATABASE_BUSINESS_WIZARD_DATA].find(task=build_wizard_data_task).first()
        logging.info('Wizard data: %s' % wizard_data_resource)
        if wizard_data_resource:
            self.Context.wizard_data_resource_id = wizard_data_resource.id
        dummy_resource = sdk2.Resource[resource_types.MAPS_DATABASE_BUSINESS_DUMMY]
        dummy = dummy_resource(self,
                               'Releasable dummy',
                               self._make_dummy())
        dummy_data = sdk2.ResourceData(dummy)
        dummy_data.ready()
