# coding: utf-8

import distutils
import logging
import os

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build.parameters import ArcadiaPatch
from sandbox.projects.common.build.parameters import ArcadiaUrl
from sandbox.projects.common.nanny import nanny
from sandbox.projects.OrgCollections.resources import MapsSearchConfigCollections
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.geosearch.resource_types import MAPS_SEARCH_CONFIG_OBJECT


class Params:

    params = (
        ArcadiaUrl,
        ArcadiaPatch,
    )


class BuildGeosearchConfigs(nanny.ReleaseToNannyTask, YaMakeTask):
    """
        Сборка конфигов для геометапоиска из svn
    """
    type = "BUILD_GEOSEARCH_CONFIGS"

    input_parameters = Params.params

    config_types = {"business": resource_types.MAPS_SEARCH_CONFIG_BASE,
                    "collections": MapsSearchConfigCollections,
                    "objects": MAPS_SEARCH_CONFIG_OBJECT,
                    }

    def on_enqueue(self):
        self.ctx['build_system'] = 'ya'
        YaMakeTask.on_enqueue(self)
        channel.task = self

        for name, tp in self.config_types.iteritems():
            self.create_resource(
                self.descr,
                os.path.join(name, '{}.cfg'.format(name)),
                tp,
                attributes={
                    "ttl": 90
                },
                arch="any",
            )

    def on_execute(self):
        data_dir = {}
        targets = []
        for t in self.config_types.keys():
            data_dir[t] = self.abs_path(t)
            if not os.path.isdir(data_dir[t]):
                os.mkdir(data_dir[t])
            targets.append(os.path.join('extsearch/geo/kernel/config', t))

        self.config_dirs = data_dir

        self.ctx['targets'] = ';'.join(targets)
        YaMakeTask.on_execute(self)

    def post_build(self, source_dir, output_dir, pack_dir):
        YaMakeTask.post_build(self, source_dir, output_dir, pack_dir)
        for t in self.config_types.keys():
            export_ya_make_result(
                os.path.join(output_dir, 'extsearch/geo/kernel/config', t),
                self.config_dirs[t],
            )


def svn_subfolder_url(svn_url, subfolder):
    svn_info = Arcadia.info(svn_url)
    return "{}/{}@{}".format(svn_info["url"], subfolder, svn_info["entry_revision"])


def export_ya_make_result(src_dir, dst_dir):
    logging.info('export_ya_make_result {} {}'.format(src_dir, dst_dir))
    distutils.dir_util.copy_tree(src_dir, dst_dir)  # use replace copytree version


__Task__ = BuildGeosearchConfigs
