# coding: utf-8

import distutils
import json
import logging
import os
import time

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.build.parameters import ArcadiaPatch
from sandbox.projects.common.build.parameters import ArcadiaUrl
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.svn import Arcadia


class Params:

    params = [
        ArcadiaUrl,
        ArcadiaPatch,
    ] + build_params.get_aapi_parameters_as_default()


class BuildGeosearchData(nanny.ReleaseToNannyTask, YaMakeTask):
    """
        Сборка данных для геометапоиска из svn
    """
    type = "BUILD_GEOSEARCH_DATA"

    input_parameters = Params.params

    def on_enqueue(self):
        self.ctx['build_system'] = 'ya'
        YaMakeTask.on_enqueue(self)
        channel.task = self
        self.create_resource(
            self.descr,
            "data",
            resource_types.MIDDLESEARCH_GEO_DATA,
            attributes={
                "ttl": 90,
            },
            arch="any",
        )

    def on_execute(self):
        data_dir = self.abs_path("data")
        if not os.path.isdir(data_dir):
            os.mkdir(data_dir)

        self.data_dir = data_dir
        self.ctx['targets'] = 'extsearch/geo/meta/rearrs/data'
        YaMakeTask.on_execute(self)

    def post_build(self, source_dir, output_dir, pack_dir):
        YaMakeTask.post_build(self, source_dir, output_dir, pack_dir)
        export_ya_make_result(
            os.path.join(output_dir, 'extsearch/geo/meta/rearrs/data/'),
            os.path.join(self.data_dir, 'geosearch'),
        )

        info = {
            'resource_timestamp': int(time.time())
        }
        with open(os.path.join(self.data_dir, 'geosearch', 'shard_info.json'), 'w') as fd:
            json.dump(info, fd)


def svn_subfolder_url(svn_url, subfolder):
    svn_info = Arcadia.info(svn_url)
    return "{}/{}@{}".format(svn_info["url"], subfolder, svn_info["entry_revision"])


def export_ya_make_result(src_dir, dst_dir):
    logging.info('export_ya_make_result {} {}'.format(src_dir, dst_dir))
    distutils.dir_util.copy_tree(src_dir, dst_dir)  # use replace copytree version


__Task__ = BuildGeosearchData
