import logging
from sandbox import sdk2
import sandbox.sdk2.helpers
from sandbox.sdk2.helpers import subprocess
from sandbox.projects.resource_types import ADDRS_BUSINESS_SHARD


class AddrsIndexCounts(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['karas-pv', 'evelkin', 'halyavin']
    shard_id = sdk2.parameters.Integer('Shard Id')


class IdxConverterExecutable(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['karas-pv', 'evelkin', 'halyavin']


class IdxPantherSqConverterExecutable(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['karas-pv', 'evelkin', 'halyavin']


class IdxPantherAttrSqConverterExecutable(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['karas-pv', 'evelkin', 'halyavin']


class BuildGeosearchIndexCounts(sdk2.Task):
    """
        Building word and pair of words stats which are needed to
        create panther indices.
    """

    class Requirements(sdk2.Task.Requirements):
        ram = 30 * 1024
        disk_space = 100 * 1024

    class Parameters(sdk2.Task.Parameters):
        shard_resource = sdk2.parameters.Resource(
            'Business shard',
            resource_type=[ADDRS_BUSINESS_SHARD],
            required=True)
        idx_converter_resource = sdk2.parameters.Resource(
            'Index converter binary',
            resource_type=[IdxConverterExecutable],
            required=True)
        shard_id = sdk2.parameters.Integer('Shard id', default=0)

    def on_execute(self):
        counters_dir = self.path('counters')
        counters_dir.mkdir()
        shard_res = sdk2.ResourceData(self.Parameters.shard_resource)
        idx_converter = sdk2.ResourceData(self.Parameters.idx_converter_resource).path
        with sandbox.sdk2.helpers.ProcessLog(self, logger=logging.getLogger('Convert')) as pl:
            subprocess.Popen(
                [str(idx_converter),
                    '-C',
                    '--no-default-index-files',
                    '--shard-path', str(shard_res.path),
                    '-f0.1',
                    '-v',
                    '--index-file', str(shard_res.path / 'index') + ':TextIndex',
                    '--index-file', str(shard_res.path / 'indexann.') + ':AnnIndex',
                    '--index-file', str(shard_res.path / 'indexfactorann.') + ':FactorAnnIndex',
                    '--counts-path', str(counters_dir / 'indexcounts')],
                shell=False, stdout=pl.stdout, stderr=subprocess.STDOUT
            ).wait()

        counts_resource = sdk2.ResourceData(
            AddrsIndexCounts(
                self,
                self.Parameters.shard_resource.description,
                str(counters_dir),
                shard_id=int(self.Parameters.shard_id)))
        counts_resource.ready()
