import logging
from sandbox import sdk2
from sandbox.projects.resource_types import ADDRS_BUSINESS_SHARD
from sandbox.projects.geosearch.BuildGeosearchIndexCounts import IdxConverterExecutable
from sandbox.projects.geosearch.BuildGeosearchIndexCounts import BuildGeosearchIndexCounts
from sandbox.projects.geosearch.BuildGeosearchIndexCounts import AddrsIndexCounts
from sandbox.common.types.task import Status


class AddrsIndexCountsMap(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['karas-pv', 'evelkin', 'halyavin']


class BuildGeosearchIndexCountsProxy(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        ram = 1 * 1024
        disk_space = 1 * 1024

    class Parameters(sdk2.Task.Parameters):
        shard_task = sdk2.parameters.Task(
            'Basesearch shards build task',
            task_type='BUILD_MAPS_DATABASE_BUSINESS_SAAS_PROXY',
            required=True)
        idx_converter_resource = sdk2.parameters.Resource(
            'Index converter binary',
            resource_type=[IdxConverterExecutable],
            required=True)

    class Context(sdk2.Context):
        subtasks_launched = False

    def on_execute(self):
        if self.Context.subtasks_launched:
            self.create_index_counts_map()
            return
        shard_task = self.Parameters.shard_task
        build_shard_tasks = shard_task.find(task_type=sdk2.Task['BUILD_ADDRS_BASESEARCH_SHARD'])
        sub_tasks = []
        for build_shard_task in build_shard_tasks:
            logging.info(str(build_shard_task.id))
            sub_task = BuildGeosearchIndexCounts(
                self,
                description='Build counts for shard ' + str(build_shard_task.Context.shard_id),
                shard_resource=sdk2.Resource.find(task=build_shard_task, resource_type=ADDRS_BUSINESS_SHARD).first(),
                idx_converter_resource=self.Parameters.idx_converter_resource,
                shard_id=build_shard_task.Context.shard_id)
            sub_tasks.append(sub_task.enqueue())
        self.Context.subtasks_launched = True
        raise sdk2.WaitTask(sub_tasks, Status.Group.FINISH | Status.Group.BREAK, True)

    def create_index_counts_map(self):
        shard_counts_map = ''
        for task in self.find(task_type=BuildGeosearchIndexCounts):
            resource = sdk2.Resource.find(task=task, resource_type=AddrsIndexCounts).first()
            shard_counts_map += '%s %s\n' % (resource.shard_id, resource.id)
        map_resource = AddrsIndexCountsMap(self, "Index counts map", "shard_counts_map.txt")
        map_resource_data = sdk2.ResourceData(map_resource)
        map_resource_data.path.write_bytes(shard_counts_map)
        map_resource_data.ready()

    def on_release(self, parameters):
        for task in self.find():
            self.server.release(
                task_id=task.id,
                subject=parameters['release_subject'],
                type=parameters['release_status'],
                message=parameters['release_comments'])
        super(BuildGeosearchIndexCountsProxy, self).on_release(parameters)
