from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.geosearch import resource_types as geo_types
from sandbox.projects.geobase.Geodata5BinStable import resource as geobase_res
from sandbox.projects.geosuggest import resources as geosuggest_types
from sandbox.projects.resource_types import OTHER_RESOURCE
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2


class BuildGeosearchTransitGzt(ReleaseToNannyTask2, sdk2.Task):
    """
        Build gazetteer with route numbers for transit rule in begemot
    """
    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 8 * 60 * 60
        builder = sdk2.parameters.Resource(
            'Builder executable',
            resource_type=geo_types.GEOSEARCH_TRANSIT_GZT_BUILDER,
            required=True
        )

    def on_execute(self):
        executable = str(sdk2.ResourceData(self.Parameters.builder).path)

        routes = sdk2.Resource[geosuggest_types.MAPS_GEO_SUGGEST_TRANSPORT].find(attrs={'released': 'stable'}).first()
        geodata = sdk2.Resource[geobase_res.GEODATA5BIN_STABLE].find(attrs={'released': 'stable'}).first()

        gzt_bin_resource = geo_types.GEOSEARCH_TRANSIT_GZT(self, "Gzt with transit routes (binary)", "routes.gzt.bin",
                                                           ttl=14)
        gzt_bin_data = sdk2.ResourceData(gzt_bin_resource)

        gzt_hr_resource = OTHER_RESOURCE(self, "Gzt with transit routes (human readable)",
                                         "routes.gzt", ttl=14)
        gzt_hr_data = sdk2.ResourceData(gzt_hr_resource)

        cmd = [
            executable,
            "--routes", str(sdk2.ResourceData(routes).path),
            "--geodata", str(sdk2.ResourceData(geodata).path),
            "--fixlist", str(gzt_bin_data.path),
            "--hr-fixlist", str(gzt_hr_data.path),
        ]
        subprocess.check_call(cmd)

        gzt_bin_data.ready()
        gzt_hr_data.ready()
