from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects import resource_types

TMPL = '{0}\t<?xml version="1.0" encoding="UTF-8" ?><Photos xmlns="http://maps.yandex.ru/snippets/photos/1.x" xmlns:atom="http://www.w3.org/2005/Atom"><count>{1}</count></Photos>\n'


class CalcBusinessPhotosCount(sdk2.Task):
    '''
        Creates photos count file for geosearch indexer
    '''

    class Parameters(sdk2.task.Parameters):
        cluster = sdk2.parameters.String("Yt cluster", default='hahn.yt.yandex.net', required=True)
        table = sdk2.parameters.String("Table", default='//home/geosearch/sprav_photos', required=True)

    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', '0.7.34.post0', use_wheel=True),
        ]

    def on_execute(self):
        from yt.wrapper import YtClient

        token = sdk2.Vault.data('mesherin', 'YQL_TOKEN')
        cluster = self.Parameters.cluster
        table = self.Parameters.table
        client = YtClient(proxy=cluster, token=token)

        out_fn = "./org-maps-export.txt"

        with open(out_fn, 'w') as out_file:
            for r in client.read_table(table, format='dsv', raw=False):
                out_file.write(TMPL.format(r['permalink'], r['number_of_photos']))

        resource = resource_types.BUSINESS_SNIPPET_PHOTOS(self, 'Photos count dump', out_fn)
        data = sdk2.ResourceData(resource)
        data.ready()
