# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.sandboxsdk import environments
from sandbox.projects.geosearch import resource_types as geo_types
import sandbox.common.types.client as ctc

import os


class CalcInnerOrgs2(sdk2.Task):
    """
    Prepares data for inner orgs snippets calculation
    """

    class Parameters(sdk2.Task.Parameters):
        cluster = sdk2.parameters.String("YT cluster", default='hahn', required=True)
        preparer = sdk2.parameters.Resource(
            'Dump preparer',
            resource_type=geo_types.INNER_ORGS_CALCER,
            required=True
        )
        inner_orgs_out_table = sdk2.parameters.String("Output table",
                                                      default='//home/geosearch/inner_orgs/inner_orgs_company_snippets',
                                                      required=True)
        inner_categs_out_table = sdk2.parameters.String("Output table",
                                                        default='//home/geosearch/inner_orgs/inner_orgs_rubrics',
                                                        required=True)

    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', '0.7.34.post0', use_wheel=True),
        ]
        client_tags = (ctc.Tag.LINUX_PRECISE | ctc.Tag.LINUX_TRUSTY)

    def on_execute(self):
        preparer = str(sdk2.ResourceData(self.Parameters.preparer).path)
        yt_token = sdk2.Vault.data('GEOMETA-SEARCH', 'yt-token')
        prep_err = os.path.join(str(self.log_path()), 'calc_inner_orgs.err')
        exec_args = [
            preparer,
            '--cluster', self.Parameters.cluster,
            '--orgs-output', self.Parameters.inner_orgs_out_table,
            '--rubrics-output', self.Parameters.inner_categs_out_table
        ]

        os.environ['MR_RUNTIME'] = 'YT'
        os.environ['YT_TOKEN'] = yt_token

        sp.check_call(exec_args, stderr=open(prep_err, 'w'))
