# -*- coding: utf-8 -*-

import os
import time
import json
import logging
from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import get_logs_folder
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.projects.common.geosearch import task as addrs_task
from sandbox.projects.release_machine import rm_notify


@rm_notify.notify2()
class CheckGeobasesearchMmsCompability(addrs_task.AddrsBasesearchTask):

    type = 'CHECK_GEOBASESEARCH_MMS_COMPABILITY'

    input_parameters = addrs_task.AddrsBasesearchTask.basesearch_common_parameters

    def check_logfile(self, logfile_path):
        # error_string = '[EMERGENCY] Collection : autostart failed'
        error_string = 'wrong version for type mms'
        with open(logfile_path) as logfile:
            log = logfile.read()
        return error_string in log

    def on_execute(self):
        geobasesearch_output = os.path.join(get_logs_folder(), 'run_geobasesearch_business.out.txt')
        check_output_path = 'output.json'
        logging.info('Initializing geobasesearch')
        geobasesearch = self._get_addrsbasesearch()
        try:
            with geobasesearch:
                time.sleep(600)
        except SandboxSubprocessError as err:
            logging.info('Geobasesearch failed')
            logging.info('Details: %s' % err)
            pass
        data = {'mms_break': self.check_logfile(geobasesearch_output)}
        with open(check_output_path, 'w') as out:
            json.dump(data, out)
        self.create_resource(description='geobasesearch mms compability check',
                             resource_path=check_output_path,
                             resource_type=resource_types.PLAIN_TEXT,
                             attributes={'ttl': '7'})
