import sandbox.common.types.task as ctt
import sandbox.sdk2 as sdk2
import sandbox.sandboxsdk.environments as environments

from sandbox.projects.common import yt_cleaner


class CommonCleanupParameters(sdk2.Parameters):
    with sdk2.parameters.Group('Yt cleaner parameters') as cleaner_block:
        history_size = sdk2.parameters.Integer('History size', default=5, required=True)


class CleanupYtFolder(sdk2.Task):
    """Remove old tables from directory"""

    class Parameters(CommonCleanupParameters):
        with sdk2.parameters.Group('Yt parameters') as yt_block:
            with sdk2.parameters.RadioGroup('Yt host') as yt_host:
                yt_vault_token = sdk2.parameters.String("Your yt token name in vault", default="yt-token", required=True)
                yt_host.values['hahn'] = yt_host.Value(value='Hahn', default=True)
                yt_host.values['banach'] = yt_host.Value(value='Banach')
                yt_host.values["arnold"] = yt_host.Value(value="Arnold")

            path = sdk2.parameters.String('Folder path', required=True)

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        import yt.wrapper as yt

        yt_token = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)
        yt_proxy = '{}.yt.yandex.net'.format(self.Parameters.yt_host)
        yt_cleaner.clean_history_folder(
            yt.YtClient(token=yt_token, proxy=yt_proxy, config=yt.config.config),
            self.Parameters.path,
            last_tables_count=self.Parameters.history_size,
        )


def clean_folder(task, path, yt_host='hahn', yt_vault_token='yt-token', history_size=5):
    clean_task = CleanupYtFolder(
        task,
        description='Remove old tables for task {}'.format(task.id),
        notifications=task.Parameters.notifications,
        create_sub_task=False,
        path=path,
        yt_host=yt_host,
        yt_vault_token=yt_vault_token,
        history_size=history_size,
    )
    clean_task.enqueue()

    raise sdk2.WaitTask([clean_task.id], ctt.Status.Group.SUCCEED + ctt.Status.Group.SCHEDULER_FAILURE, wait_all=True)
