from typing import List, Tuple

from yalibrary.makelists_resources import do_extract_resources
from yalibrary.makelists_resources import ResourceModel


class YaMakeUtils:
    @staticmethod
    def get_current_resources(ya_make_path: str):
        for resource_model in do_extract_resources(ya_make_path, only_autoupdated=False):
            if (resource_model.source == ResourceModel.Source.FROM_SANDBOX and not resource_model.is_autoupdated):
                yield resource_model

    @staticmethod
    def replace_resources(src_path: str, dst_path: str, updates: List[Tuple[ResourceModel, int]]):
        with open(src_path) as fp:
            lines = fp.readlines()

        for resource_model, new_resource_id in updates:
            old_resource_id = resource_model.resource_id
            line = lines[resource_model.line_number]
            if str(old_resource_id) != str(new_resource_id):
                fixed_line = line.replace(str(old_resource_id), str(new_resource_id), 1)
                if line == fixed_line:
                    raise Exception('Unable to replace resource #{} with #{}'.format(old_resource_id, new_resource_id))
                lines[resource_model.line_number] = fixed_line

        with open(dst_path, 'w') as fp:
            fp.write(''.join(lines))
