import logging

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects import resource_types as rt
from sandbox.projects.geosearch import resource_types as grt


class CompareGeometasearchesParallel(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 8192
        cores = 2
        ram = 8192

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        metasearch1 = sdk2.parameters.Resource('Geometasearch 1', resource_type=rt.GEOMETASEARCH_EXECUTABLE, required=True)
        metasearch2 = sdk2.parameters.Resource('Geometasearch 2', resource_type=rt.GEOMETASEARCH_EXECUTABLE, required=True)
        configs_builder = sdk2.parameters.LastReleasedResource('Configs builder', resource_type=grt.GEOMETASEARCH_CONFIGS_BUILDER, required=True)
        rearrange_data = sdk2.parameters.LastReleasedResource('Rearrange data', resource_type=rt.MIDDLESEARCH_GEO_DATA, required=True)
        queries = sdk2.parameters.Resource('Queries', resource_type=rt.PLAIN_TEXT_QUERIES, required=True)

        binary_release = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        logging.info('OK!')
        pass
