# -*- coding: utf-8 -*-

import subprocess

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.projects.geosearch.resource_types import GEOSEARCH_IMPORTER_2
from sandbox.projects.common.nanny import nanny
import sandbox.common.types.task as ctt


class DeployAddrsImporter(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.Integer('Revision', description='Arcadia SVN revision number', default=None, required=False)
        message = sdk2.parameters.String('Message', description='Release comment', default='', required=False)

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        revision = self.Parameters.revision
        arcadia_url = Arcadia.trunk_url('search/geo/tools/importer2', revision=revision)
        Arcadia.export(arcadia_url, 'importer2')

        if revision:
            subprocess.check_call(['sed', '--in-place', 's/REVISION/{}/g'.format(revision), 'importer2/index.htm'])

        resource_data = sdk2.ResourceData(GEOSEARCH_IMPORTER_2(self, self.Parameters.message, 'importer2', ttl='inf'))
        resource_data.ready()

    def on_success(self, prev_status):
        sdk2.Task.on_success(self, prev_status)
        nanny.ReleaseToNannyTask2.on_release(self, dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject=self.Parameters.message,
            email_notifications=dict(to=[], cc=[]),
        ))
