# -*- coding: utf-8 -*-

from random import choice

from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.projects import resource_types

from sandbox.projects.GetAddrsRequests import GetAddrsRequests
from sandbox.projects.tank.Firestarter import Firestarter


class GrepGeometasearchLogs(sdk2.Task):

    class Parameters(sdk2.Parameters):
        reference_upper = sdk2.parameters.String('Reference geometasearch upper')
        reference_middle = sdk2.parameters.String('Reference geometasearch middle')
        test_upper = sdk2.parameters.String('Test geometasearch upper')
        test_middle = sdk2.parameters.String('Test geometasearch middle')
        start_time = sdk2.parameters.String('Dump logs from')
        end_time = sdk2.parameters.String('Dump logs till')
        acceptance_task = sdk2.parameters.String('Acceptance task')

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 2048

        class Caches(sdk2.Requirements.Caches):
            pass

    def get_requests(self):
        if not self.Context.get_requests_task_id:
            get_requests_task_class = sdk2.Task[GetAddrsRequests.type]
            get_requests_task = get_requests_task_class(
                self,
                location=choice(['VLA', 'SAS']),
                number_of_hosts=1,
                number_of_requests=100000,
                sample_origins_uniformly=True,
                service='Upper',
                time_interval=300,
                owner=self.owner,
                create_sub_task=True
            )
            get_requests_task.enqueue()
            self.Context.get_requests_task_id = get_requests_task.id
            raise sdk2.WaitTask(
                [self.Context.get_requests_task_id],
                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                wait_all=True
            )
            requests_res = sdk2.Resource[resource_types.PLAIN_TEXT_QUERIES].find(task=get_requests_task).first()
            return requests_res.http_proxy

    def shoot(self, host):
        firestarter_task_class = sdk2.Task[Firestarter.type]
        firestarter_task = firestarter_task_class(
            self,
            dry_run=False,
            monitoring_config='',
            tank_config='''
bfg:
    package: yandextank.plugins.Bfg
console:
    enabled: false
metaconf:
    enabled: true
    firestarter: {{
        tank: addrs-tank-1.vla.yp-c.yandex.net
    }}
phantom:
    address: '{host}'
    ammofile: '{requests_url}'
    cache_dir: /place/db/www/logs/yandex-tank/tankapi/tests/stpd-cache
    load_profile: {{
        load_type: rps,
        schedule: 'const(100, 30m)'
    }}
    package: yandextank.plugins.Phantom
    uris: []
telegraf:
    enabled: false
    package: yandextank.plugins.Telegraf
uploader:
    enabled: true
    meta: {{
        use_tank: addrs-tank-1.vla.yp-c.yandex.net,
        use_tank_port: 80
    }}
    operator: {owner}
    package: yandextank.plugins.DataUploader
    task: {ticket}
            '''.format(
                host=host,
                requests_url=self.Context.requests_link,
                owner=self.author,
                ticket=self.Parameters.acceptance_task
            ),
            use_last_binary=True,
            wait_finish=False,
            owner=self.author,
            create_sub_task=True
        )
        firestarter_task.enqueue()
        return firestarter_task.id

    def parse(self, service):
        pass

    def compare(self, reference_data, test_data):
        pass

    def on_execute(self):
        with self.memoize_stage.get_requests(commit_on_entrance=False):
            self.Context.requests_link = self.get_requests()
        with self.memoize_stage.shoot(commit_on_entrance=False):
            self.Context.reference_shooting_task_id = self.shoot(self.Parameters.reference_upper)
            self.Context.test_shooting_task_id = self.shoot(self.Parameters.test_upper)
            raise sdk2.WaitTask(
                [
                    self.Context.reference_shooting_task_id,
                    self.Context.test_shooting_task_id
                ],
                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                wait_all=True
            )
